/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.desktop;

import java.util.List;
import java.util.Properties;
import org.adempiere.util.Callback;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.apps.ProcessDialog;
import org.adempiere.webui.apps.wf.WFPanel;
import org.adempiere.webui.component.DesktopTabpanel;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.desktop.AbstractDesktop;
import org.adempiere.webui.factory.InfoManager;
import org.adempiere.webui.info.InfoWindow;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.part.WindowContainer;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.WTask;
import org.compiere.model.MForm;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MQuery;
import org.compiere.model.MTask;
import org.compiere.model.SystemProperties;
import org.compiere.util.Env;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Window;

public abstract class TabbedDesktop
extends AbstractDesktop {
    protected WindowContainer windowContainer = new WindowContainer();

    @Override
    public ProcessDialog openProcessDialog(int processId, boolean soTrx) {
        ProcessDialog pd = new ProcessDialog(processId, soTrx, this.getPredefinedContextVariables());
        if (pd.isValid()) {
            DesktopTabpanel tabPanel = new DesktopTabpanel();
            pd.setParent((Component)tabPanel);
            String title = pd.getTitle();
            pd.setTitle(null);
            this.preOpenNewTab();
            this.windowContainer.addWindow((Component)tabPanel, title, true, null);
            Events.postEvent((String)"onInitialFocus", (Component)pd, null);
        }
        return pd;
    }

    @Override
    public ADForm openForm(int formId) {
        ADForm form = ADForm.openForm(formId, null, null, this.getPredefinedContextVariables(), this.isMenuSOTrx());
        if (Window.Mode.EMBEDDED == form.getWindowMode()) {
            DesktopTabpanel tabPanel = new DesktopTabpanel();
            form.setParent((Component)tabPanel);
            form.setTitle(null);
            this.preOpenNewTab();
            this.windowContainer.addWindow((Component)tabPanel, form.getFormName(), true, Tab.DecorateInfo.get(MForm.get((int)formId)));
            form.focus();
        } else {
            form.setAttribute("mode", form.getWindowMode());
            this.showWindow(form);
        }
        return form;
    }

    @Override
    public void openInfo(int infoId) {
        InfoWindow infoPanel = InfoManager.create(infoId, this.getPredefinedContextVariables());
        if (infoPanel != null) {
            DesktopTabpanel tabPanel = new DesktopTabpanel();
            infoPanel.setParent((Component)tabPanel);
            String title = infoPanel.getTitle();
            infoPanel.setTitle(null);
            this.preOpenNewTab();
            this.windowContainer.addWindow((Component)tabPanel, title, true, Tab.DecorateInfo.get(MInfoWindow.get((int)infoId, null)));
            infoPanel.focus();
        } else {
            Dialog.error(0, "NotValid");
        }
    }

    @Override
    public void openWorkflow(int workflow_ID) {
        WFPanel p = new WFPanel();
        p.load(workflow_ID);
        DesktopTabpanel tabPanel = new DesktopTabpanel();
        p.setParent((Component)tabPanel);
        this.preOpenNewTab();
        this.windowContainer.addWindow((Component)tabPanel, p.getWorkflow().get_Translation("Name"), true, null);
    }

    @Override
    public void openWindow(int windowId, Callback<ADWindow> callback) {
        this.openWindow(windowId, null, callback);
    }

    @Override
    public void openWindow(int windowId, MQuery query, Callback<ADWindow> callback) {
        ADWindow adWindow = new ADWindow(Env.getCtx(), windowId, query);
        DesktopTabpanel tabPanel = new DesktopTabpanel();
        int windowNo = adWindow.getADWindowContent().getWindowNo();
        if (SystemProperties.isZkUnitTest()) {
            String id = AdempiereIdGenerator.escapeId(adWindow.getTitle());
            tabPanel.setId(id + "_" + windowNo);
        }
        org.adempiere.webui.component.Tab tab = this.windowContainer.addWindow((Component)tabPanel, adWindow.getTitle(), true, Tab.DecorateInfo.get(adWindow));
        tab.setClosable(false);
        OpenWindowRunnable runnable = new OpenWindowRunnable(adWindow, tab, tabPanel, callback);
        Env.setPredefinedVariables((Properties)Env.getCtx(), (int)windowNo, (String)this.getPredefinedContextVariables());
        this.preOpenNewTab();
        runnable.run();
    }

    @Override
    public void openTask(int taskId) {
        MTask task = new MTask(Env.getCtx(), taskId, null);
        new WTask(task.getName(), task);
    }

    @Override
    public void showURL(String url, boolean closeable) {
        this.showURL(url, url, closeable);
    }

    public void showURL(String url, String title, boolean closeable) {
        Iframe iframe = new Iframe(url);
        this.addWin(iframe, title, closeable);
    }

    @Override
    public void showHTMLContent(String content, String title, boolean closeable) {
        Iframe iframe = new Iframe();
        AMedia media = new AMedia(title, "html", "text/html", content.getBytes());
        iframe.setContent((Media)media);
        this.addWin(iframe, title, closeable);
    }

    private void addWin(Iframe fr, String title, boolean closeable) {
        ZKUpdateUtil.setWidth((HtmlBasedComponent)fr, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)fr, "100%");
        fr.setStyle("padding: 0; margin: 0; border: none; position: absolute");
        Window window = new Window();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)window, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)window, "100%");
        window.setStyle("padding: 0; margin: 0; border: none");
        window.appendChild((Component)fr);
        window.setStyle("position: absolute");
        Tabpanel tabPanel = new Tabpanel();
        window.setParent((Component)tabPanel);
        this.preOpenNewTab();
        this.windowContainer.addWindow((Component)tabPanel, title, closeable, null);
    }

    @Override
    public void showZoomWindow(int AD_Window_ID, MQuery query) {
        ADWindow wnd = new ADWindow(Env.getCtx(), AD_Window_ID, query);
        DesktopTabpanel tabPanel = new DesktopTabpanel();
        org.adempiere.webui.component.Tab tab = this.windowContainer.insertAfter(this.windowContainer.getSelectedTab(), (Component)tabPanel, wnd.getTitle(), true, true, Tab.DecorateInfo.get(wnd));
        tab.setClosable(false);
        OpenWindowRunnable runnable = new OpenWindowRunnable(wnd, tab, tabPanel, null);
        this.preOpenNewTab();
        runnable.run();
    }

    @Override
    public void showWindow(int AD_Window_ID, MQuery query) {
        this.openWindow(AD_Window_ID, query, null);
    }

    @Override
    protected void showEmbedded(Window window) {
        Tabpanel tabPanel = new Tabpanel();
        window.setParent((Component)tabPanel);
        Object defer = window.getAttribute("deferSetSelectedTab");
        if (defer != null) {
            tabPanel.setAttribute("deferSetSelectedTab", defer);
        }
        String title = window.getTitle();
        window.setTitle(null);
        this.preOpenNewTab();
        if ("insertNext".equals(window.getAttribute("insertPosition"))) {
            this.windowContainer.insertAfter(this.windowContainer.getSelectedTab(), (Component)tabPanel, title, true, true, null);
        } else if ("replace".equals(window.getAttribute("insertPosition"))) {
            org.adempiere.webui.component.Tab refTab = this.windowContainer.getSelectedTab();
            Object windowNoAttribute = window.getAttribute("replaceWindowNo");
            if (windowNoAttribute != null && windowNoAttribute instanceof Integer) {
                int windowNo = (Integer)windowNoAttribute;
                refTab = this.windowContainer.getTab(windowNo);
            }
            if (refTab == null) {
                this.windowContainer.addWindow((Component)tabPanel, title, true, null);
            } else {
                this.windowContainer.replace(refTab, window, title);
            }
        } else {
            this.windowContainer.addWindow((Component)tabPanel, title, true, null);
        }
        if (window instanceof IHelpContext) {
            Events.sendEvent((Event)new Event("onWindowContainerSelectionChanged", (Component)window));
        }
    }

    @Override
    public boolean closeActiveWindow() {
        if (this.windowContainer.getSelectedTab() != null) {
            Tabpanel panel = (Tabpanel)this.windowContainer.getSelectedTab().getLinkedPanel();
            Component component = panel.getFirstChild();
            Object att = component.getAttribute("desktop.windowno");
            if (this.windowContainer.closeActiveWindow()) {
                if (att != null && att instanceof Integer) {
                    this.unregisterWindow((Integer)att);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Component getActiveWindow() {
        return this.windowContainer.getSelectedTab().getLinkedPanel().getFirstChild();
    }

    @Override
    public boolean closeWindow(int windowNo) {
        Tabbox tabbox = this.windowContainer.getComponent();
        Tabpanels panels = tabbox.getTabpanels();
        List childrens = panels.getChildren();
        for (Object child : childrens) {
            Object att;
            Tabpanel panel = (Tabpanel)child;
            Component component = panel.getFirstChild();
            Object object = att = component != null ? component.getAttribute("desktop.windowno") : null;
            if (att == null || !(att instanceof Integer) || windowNo != (Integer)att) continue;
            Tab tab = panel.getLinkedTab();
            if (tab != null) {
                panel.getLinkedTab().onClose();
                if (tab.getParent() == null) {
                    this.unregisterWindow(windowNo);
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected void preOpenNewTab() {
    }

    @Override
    public void setTabTitle(String title, int windowNo) {
        this.windowContainer.setTabTitle(title, windowNo);
    }

    class OpenWindowRunnable
    implements Runnable {
        private final ADWindow adWindow;
        private final Tab tab;
        private final DesktopTabpanel tabPanel;
        private Callback<ADWindow> callback;

        protected OpenWindowRunnable(ADWindow adWindow, Tab tab, DesktopTabpanel tabPanel, Callback<ADWindow> callback) {
            this.adWindow = adWindow;
            this.tab = tab;
            this.tabPanel = tabPanel;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (this.adWindow.createPart(this.tabPanel) != null) {
                this.tab.setClosable(true);
                if (this.callback != null) {
                    this.callback.onCallback((Object)this.adWindow);
                }
            } else {
                this.tab.onClose();
            }
        }
    }
}

